

struct SplinePosVel
{
    float3 Pos;
	float Vel ;
	
};

StructuredBuffer<SplinePosVel> sbPosition;

int TotalCount;


RWStructuredBuffer<SplinePosVel> PositionBuffer : BACKBUFFER;

[numthreads(512, 1, 1)]
void GetsliceBuffer( uint3 i : SV_DispatchThreadID)
{ 
	//Safeguard if we don't use a multiple
	if (i.x >=TotalCount) { return;}

	
	
	

    PositionBuffer[i.x]=sbPosition[i.x];
	
}


technique11 GetsliceBufferT
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, GetsliceBuffer() ) );
	}
}







